from pydantic import BaseModel, Field
from typing import Optional
from datetime import datetime

class WorkforceTimesheet(BaseModel):
    account_id: str = Field(..., description="Identifier for the account")
    user_id: str = Field(..., description="Identifier for the user")
    workforce_id: str = Field(..., description="Identifier for the workforce member")
    vehicle_id: Optional[str] = Field(None, description="Vehicle used during shift")
    shift_in: datetime = Field(..., description="Start time of the shift")
    shift_out: Optional[datetime] = Field(None, description="End time of the shift")
    status: bool = Field(..., description="Shift status (true=complete, false=inactive)")
    created_date: datetime = Field(default_factory=datetime.utcnow)
    updated_date: datetime = Field(default_factory=datetime.utcnow)
